/*
 * Decompiled with CFR 0.152.
 */
package corgiaoc.byg.common.entity.tileentities;

import corgiaoc.byg.client.gui.HypogealImperiumContainer;
import corgiaoc.byg.common.properties.blocks.nether.HypogealImperiumBlock;
import corgiaoc.byg.core.BYGItems;
import corgiaoc.byg.core.BYGTileEntities;
import corgiaoc.byg.helper.BlockEntityPacketHandler;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IIntArray;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class HypogealImperiumTE
extends LockableLootTileEntity
implements ITickableTileEntity,
BlockEntityPacketHandler {
    private NonNullList<ItemStack> contents = NonNullList.func_191197_a((int)20, (Object)ItemStack.field_190927_a);
    protected int numPlayersUsing;
    protected int crystal = 0;
    public int fuel;
    public int damageTime;
    private final IIntArray dataAccess = new IIntArray(){

        public int func_221476_a(int index) {
            if (index == 0) {
                return HypogealImperiumTE.this.fuel;
            }
            return 0;
        }

        public void func_221477_a(int index, int value) {
            HypogealImperiumTE.this.fuel = value;
        }

        public int func_221478_a() {
            return 1;
        }
    };

    public HypogealImperiumTE() {
        super(BYGTileEntities.HYPOGEAL);
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT nbtTag = super.func_189517_E_();
        nbtTag.func_74768_a("Crystal", this.getCrystal());
        nbtTag.func_74777_a("Fuel", (short)this.fuel);
        return nbtTag;
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.func_174877_v(), -1, this.func_189517_E_());
    }

    @Override
    public void handleClientPacketNoTypeCheck(SUpdateTileEntityPacket packet) {
        this.readData(packet.func_148857_g());
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.readData(nbt);
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_74777_a("Fuel", (short)this.fuel);
        compound.func_74768_a("Crystal", this.getCrystal());
        if (!this.func_184282_c(compound)) {
            ItemStackHelper.func_191282_a((CompoundNBT)compound, this.contents);
        }
        return compound;
    }

    private void readData(CompoundNBT nbt) {
        this.contents = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        this.fuel = nbt.func_74765_d("Fuel");
        this.setCrystal(nbt.func_74762_e("Crystal"));
        if (!this.func_184283_b(nbt)) {
            ItemStackHelper.func_191283_b((CompoundNBT)nbt, this.contents);
        }
    }

    public void func_73660_a() {
        this.playSound();
        this.addEffectsToMobs();
        this.changeBlocksInRadius();
        this.doCrystalLoad();
        this.addParticles();
        this.setLit();
    }

    public void playSound() {
        if (this.isLit() && this.field_145850_b.func_82737_E() % 80L == 0L) {
            this.field_145850_b.func_184134_a((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), SoundEvents.field_206939_L, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
        }
    }

    public void setLit() {
        if (this.isLit()) {
            this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)this.field_145850_b.func_180495_p(this.field_174879_c).func_206870_a((Property)HypogealImperiumBlock.LIT, (Comparable)Boolean.valueOf(this.isLit())), 3);
            this.func_70296_d();
        }
    }

    public void doCrystalLoad() {
        ItemStack itemFuelItem = this.func_70301_a(0);
        ItemStack itemCatalystItem = this.func_70301_a(1);
        ItemStack resultItem = this.func_70301_a(2);
        if (this.getCrystal() < 12) {
            if (itemFuelItem.func_77973_b() == BYGItems.SUBZERO_CRYSTAL_SHARD && this.getFuel() <= 0) {
                this.setFuel(9);
                itemFuelItem.func_190918_g(1);
            }
            if (itemCatalystItem.func_77973_b() == BYGItems.SUBZERO_CRYSTAL_CLUSTER && this.getFuel() > 0) {
                this.setFuel(this.getFuel() - 1);
                itemCatalystItem.func_190918_g(1);
                this.setCrystal(this.getCrystal() + 1);
                this.func_145831_w().func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 13);
                if (resultItem.func_77973_b() != BYGItems.SUBZERO_CRYSTAL_CLUSTER) {
                    this.func_70299_a(2, BYGItems.SUBZERO_CRYSTAL_CLUSTER.func_190903_i());
                }
                if (resultItem.func_77973_b() == BYGItems.SUBZERO_CRYSTAL_CLUSTER) {
                    resultItem.func_190920_e(resultItem.func_190916_E() + 1);
                }
            }
        }
    }

    public void addParticles() {
        World world = this.field_145850_b;
        int h = 6 + this.getCrystal();
        for (int x1 = this.func_174877_v().func_177958_n() - h; x1 <= this.func_174877_v().func_177958_n() + h; ++x1) {
            for (int y1 = this.func_174877_v().func_177956_o(); y1 <= this.func_174877_v().func_177956_o() + 6; ++y1) {
                for (int z1 = this.func_174877_v().func_177952_p() - h; z1 <= this.func_174877_v().func_177952_p() + h; ++z1) {
                    Random rand;
                    int i;
                    if (!this.field_145850_b.field_72995_K || this.getFuel() <= 0 || (i = (rand = new Random()).nextInt(7)) < 4) continue;
                    world.func_195594_a((IParticleData)ParticleTypes.field_239820_at_, (double)x1, (double)y1, (double)z1, 0.0, 5.0E-4, 0.0);
                }
            }
        }
    }

    public void addEffectsToMobs() {
        if (!this.field_145850_b.field_72995_K) {
            AxisAlignedBB axisalignedbb = new AxisAlignedBB(this.field_174879_c).func_186662_g((double)(6 + this.getCrystal())).func_72321_a(0.0, (double)this.field_145850_b.func_234938_ad_(), 0.0);
            List list = this.field_145850_b.func_217357_a(MonsterEntity.class, axisalignedbb);
            for (MonsterEntity mob : list) {
                if (this.getFuel() <= 0) continue;
                mob.func_195064_c(new EffectInstance(Effects.field_76421_d, 20, 3, false, true));
                --this.damageTime;
                if (this.damageTime > 0) continue;
                mob.func_70097_a(DamageSource.field_76376_m, 2.0f);
                this.useFuel();
                this.damageTime = 100;
            }
        }
    }

    public void changeBlocksInRadius() {
        World world = this.field_145850_b;
        if (this.getFuel() > 0) {
            int h = 6 + this.getCrystal();
            for (int x1 = this.func_174877_v().func_177958_n() - h; x1 <= this.func_174877_v().func_177958_n() + h; ++x1) {
                for (int y1 = this.func_174877_v().func_177956_o() - 2; y1 <= this.func_174877_v().func_177956_o() + 5; ++y1) {
                    for (int z1 = this.func_174877_v().func_177952_p() - h; z1 <= this.func_174877_v().func_177952_p() + h; ++z1) {
                        if (world.field_72995_K) continue;
                        if (world.func_180495_p(new BlockPos(x1, y1, z1)) == Blocks.field_150355_j.func_176223_P()) {
                            world.func_175656_a(new BlockPos(x1, y1, z1), Blocks.field_150432_aD.func_176223_P());
                            this.useFuel();
                        }
                        if (world.func_180495_p(new BlockPos(x1, y1, z1)) != Blocks.field_150353_l.func_176223_P()) continue;
                        world.func_175656_a(new BlockPos(x1, y1, z1), Blocks.field_150343_Z.func_176223_P());
                        this.useFuel();
                    }
                }
            }
        }
    }

    public void useFuel() {
        Random random = new Random();
        int useFuel = random.nextInt(11);
        if (useFuel > 9) {
            this.setFuel(this.getFuel() - 1);
        }
    }

    protected ITextComponent func_213907_g() {
        return new TranslationTextComponent("container.hypogeal_imperium_container");
    }

    protected Container func_213906_a(int id, PlayerInventory player) {
        return new HypogealImperiumContainer(id, player, (IInventory)this, this.dataAccess);
    }

    public boolean func_145842_c(int id, int type) {
        if (id == 1) {
            this.numPlayersUsing = type;
            return true;
        }
        return super.func_145842_c(id, type);
    }

    public void func_174889_b(PlayerEntity player) {
        if (!player.func_175149_v()) {
            if (this.numPlayersUsing < 0) {
                this.numPlayersUsing = 0;
            }
            ++this.numPlayersUsing;
            this.onOpenOrClose();
        }
    }

    public void func_174886_c(PlayerEntity player) {
        if (!player.func_175149_v()) {
            --this.numPlayersUsing;
            this.onOpenOrClose();
        }
    }

    protected void onOpenOrClose() {
        Block block = this.func_195044_w().func_177230_c();
        if (block instanceof HypogealImperiumBlock) {
            this.field_145850_b.func_175641_c(this.field_174879_c, block, 1, this.numPlayersUsing);
            this.field_145850_b.func_195593_d(this.field_174879_c, block);
        }
    }

    public int func_70302_i_() {
        return 20;
    }

    public int func_70297_j_() {
        return 64;
    }

    public NonNullList<ItemStack> func_190576_q() {
        return this.contents;
    }

    protected void func_199721_a(NonNullList<ItemStack> itemsIn) {
        this.contents = itemsIn;
    }

    public int getFuel() {
        return this.fuel;
    }

    public void setFuel(int amount) {
        this.fuel = amount;
    }

    public int getCrystal() {
        return this.crystal;
    }

    public void setCrystal(int amount) {
        this.crystal = amount;
    }

    private boolean isLit() {
        return this.getFuel() > 0;
    }
}

